<?php

namespace App\Models\Demarches;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Actualite extends Model 
{

    protected $table = 'actualites';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('titre', 'description', 'contenu', 'url', 'observations', 'date_derniere_modification', 'etat', 'est_publie', 'add_by');

    public function demarches()
    {
        return $this->belongsToMany('App\Models\Demarches\Demarche');
    }

    public function sousThemes()
    {
        return $this->belongsToMany('App\Models\Demarches\SousTheme');
    }

    public function serviceAdministratifs()
    {
        return $this->belongsToMany('App\Models\Demarches\ServiceAdministratif');
    }

    public function textes()
    {
        return $this->belongsToMany('App\Models\Demarches\Texte');
    }

}